// generated by diplomat-tool
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { Locale } from "./Locale"
import type { TitlecaseOptions } from "./TitlecaseOptions"
import type { TitlecaseOptions_obj } from "./TitlecaseOptions"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * See the [Rust documentation for `TitlecaseMapper`](https://docs.rs/icu/latest/icu/casemap/struct.TitlecaseMapper.html) for more information.
 */


export class TitlecaseMapper {
    get ffiValue(): pointer;


    /**
     * Construct a new `TitlecaseMapper` instance using a particular data source.
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/casemap/struct.TitlecaseMapper.html#method.new) for more information.
     */
    static createWithProvider(provider: DataProvider): TitlecaseMapper;

    /**
     * Returns the full titlecase mapping of the given string
     *
     * The `v1` refers to the version of the options struct, which may change as we add more options
     *
     * See the [Rust documentation for `titlecase_segment`](https://docs.rs/icu/latest/icu/casemap/struct.TitlecaseMapperBorrowed.html#method.titlecase_segment) for more information.
     */
    titlecaseSegment(s: string, locale: Locale, options: TitlecaseOptions_obj): string;

    /**
     * Returns the full titlecase mapping of the given string, using compiled data (avoids having to allocate a TitlecaseMapper object)
     *
     * The `v1` refers to the version of the options struct, which may change as we add more options
     *
     * See the [Rust documentation for `titlecase_segment`](https://docs.rs/icu/latest/icu/casemap/struct.TitlecaseMapperBorrowed.html#method.titlecase_segment) for more information.
     */
    static titlecaseSegmentWithCompiledData(s: string, locale: Locale, options: TitlecaseOptions_obj): string;

    constructor();
}