package Yukki::Web::View::Attachment;
$Yukki::Web::View::Attachment::VERSION = '0.991_007'; # TRIAL
$Yukki::Web::View::Attachment::VERSION = '0.991007';
use v5.24;
use utf8;
use Moo;

use Type::Utils;

use namespace::clean;

extends 'Yukki::Web::View';

# ABSTRACT: View for attachment forms


has rename_template => (
    is          => 'ro',
    isa         => class_type('Template::Pure'),
    lazy        => 1,
    builder     => '_build_rename_template',
);

sub _build_rename_template {
    shift->prepare_template(
        template   => 'attachment/rename.html',
        directives => [
            '#yukkiname'           => 'page',
            '#yukkiname_new@value' => 'page',
        ],
    );
}

has remove_template => (
    is          => 'ro',
    isa         => class_type('Template::Pure'),
    lazy        => 1,
    builder     => '_build_remove_template',
);

sub _build_remove_template {
    shift->prepare_template(
        template   => 'attachment/remove.html',
        directives => [
            '.yukkiname'          => 'page',
            '#cancel_remove@href' => 'return_link',
        ],
    );
}


sub rename {
    my ($self, $ctx, $vars) = @_;
    my $file = $vars->{file};

    $ctx->response->page_title($vars->{title});

    return $self->render_page(
        template => $self->rename_template,
        context  => $ctx,
        vars     => $vars,
    );
}


sub remove {
    my ($self, $ctx, $vars) = @_;
    my $file = $vars->{file};

    $ctx->response->page_title($vars->{title});

    return $self->render_page(
        template => $self->remove_template,
        context  => $ctx,
        vars     => $vars,
    );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Yukki::Web::View::Attachment - View for attachment forms

=head1 VERSION

version 0.991_007

=head1 DESCRIPTION

Handles the display of attachment forms.

=head1 METHODS

=head2 rename

Show the rename form for attachments.

=head2 remove

Show the remove form for attachmensts.

=head1 AUTHOR

Andrew Sterling Hanenkamp <hanenkamp@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Qubling Software LLC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
