/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLGlobalParam;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceBinding {
    private StyleElement sourceElement;
    private StructuredQName name;
    private Expression select = null;
    private SequenceType declaredType = null;
    private SequenceType inferredType = null;
    protected String constantText = null;
    protected SlotManager slotManager = null;
    private Visibility visibility;
    private GroundedValue constantValue = null;
    private int properties;
    public static final int PRIVATE = 1;
    public static final int GLOBAL = 2;
    public static final int PARAM = 4;
    public static final int TUNNEL = 8;
    public static final int REQUIRED = 16;
    public static final int IMPLICITLY_REQUIRED = 32;
    public static final int ASSIGNABLE = 64;
    public static final int SELECT = 128;
    public static final int AS = 256;
    public static final int DISALLOWS_CONTENT = 512;
    public static final int STATIC = 2048;
    public static final int VISIBILITY = 4096;
    public static final int IMPLICITLY_DECLARED = 8192;
    private List<BindingReference> references = new ArrayList<BindingReference>(10);

    public SourceBinding(StyleElement sourceElement) {
        this.sourceElement = sourceElement;
    }

    public void prepareAttributes(int permittedAttributes) throws XPathException {
        AttributeCollection atts = this.sourceElement.getAttributeList();
        String selectAtt = null;
        String asAtt = null;
        String requiredAtt = null;
        String tunnelAtt = null;
        String assignableAtt = null;
        String staticAtt = null;
        String visibilityAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                if (this.name != null && !this.name.equals(this.errorName())) continue;
                this.processVariableName(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                if ((permittedAttributes & 0x80) != 0) {
                    selectAtt = atts.getValue(a);
                    continue;
                }
                this.sourceElement.compileErrorInAttribute("The select attribute is not permitted on a function parameter", "XTSE0760", "select");
                continue;
            }
            if (f.equals("as") && (permittedAttributes & 0x100) != 0) {
                asAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("required") && (permittedAttributes & 0x10) != 0) {
                requiredAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("tunnel")) {
                tunnelAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("static") && (permittedAttributes & 0x800) != 0) {
                staticAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("visibility") && (permittedAttributes & 0x1000) != 0) {
                visibilityAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (atts.getLocalName(a).equals("assignable") && "http://saxon.sf.net/".equals(atts.getURI(a)) && (permittedAttributes & 0x40) != 0) {
                assignableAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.sourceElement.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.name == null) {
            this.sourceElement.reportAbsence("name");
            this.name = this.errorName();
        }
        if (selectAtt != null) {
            this.select = this.sourceElement.makeExpression(selectAtt, this.sourceElement.getAttributeList().getIndex("", "select"));
        }
        if (requiredAtt != null) {
            boolean required = this.sourceElement.processBooleanAttribute("required", requiredAtt);
            this.setProperty(16, required);
            if (required && this.select != null) {
                this.sourceElement.compileError("xsl:param: cannot supply a default value when required='yes'");
            }
        }
        if (tunnelAtt != null) {
            boolean tunnel = this.sourceElement.processBooleanAttribute("tunnel", tunnelAtt);
            if (tunnel && (permittedAttributes & 8) == 0) {
                this.sourceElement.compileErrorInAttribute("The only permitted value of the 'tunnel' attribute is 'no'", "XTSE0020", "tunnel");
            }
            this.setProperty(8, tunnel);
        }
        if (assignableAtt != null) {
            boolean assignable = this.sourceElement.processBooleanAttribute("saxon:assignable", assignableAtt);
            this.setProperty(64, assignable);
        }
        if (staticAtt != null) {
            boolean statick = this.sourceElement.processBooleanAttribute("static", staticAtt);
            this.setProperty(2048, statick);
            if (statick) {
                this.setProperty(512, true);
            }
            if (statick && !this.hasProperty(2)) {
                this.sourceElement.compileErrorInAttribute("Only global declarations can be static", "XTSE0020", "static");
            }
        }
        if (asAtt != null) {
            try {
                this.declaredType = this.sourceElement.makeSequenceType(asAtt);
            }
            catch (XPathException e) {
                this.sourceElement.compileErrorInAttribute(e.getMessage(), e.getErrorCodeLocalPart(), "as");
            }
        }
        if (visibilityAtt != null) {
            if (this.hasProperty(4)) {
                this.sourceElement.compileErrorInAttribute("The visibility attribute is not allowed on xsl:param", "XTSE0020", "visibility");
            } else {
                this.sourceElement.check30attribute("visibility");
                this.visibility = this.sourceElement.interpretVisibilityValue(visibilityAtt, "");
            }
            if (!this.hasProperty(2)) {
                this.sourceElement.compileErrorInAttribute("The visibility attribute is allowed only on global declarations", "XTSE0020", "visibility");
            }
        }
        if (this.hasProperty(2048) && this.visibility != Visibility.PRIVATE && visibilityAtt != null) {
            this.sourceElement.compileErrorInAttribute("A static variable or parameter must be private", "XTSE0020", "static");
        }
    }

    public StyleElement getSourceElement() {
        return this.sourceElement;
    }

    public void setVariableQName(StructuredQName name) {
        this.name = name;
    }

    public void setDeclaredType(SequenceType declaredType) {
        this.declaredType = declaredType;
    }

    private void processVariableName(String nameAttribute) throws XPathException {
        try {
            if (nameAttribute != null) {
                this.name = this.sourceElement.makeQName(nameAttribute);
            }
        }
        catch (NamespaceException err) {
            this.name = this.errorName();
            StructuredQName n = StructuredQName.fromClarkName("name");
            throw new XPathException("Invalid variable name: " + err.getMessage(), "XTSE0020", new AttributeLocation(this.sourceElement, n));
        }
        catch (XPathException err) {
            this.name = this.errorName();
            StructuredQName n = StructuredQName.fromClarkName("name");
            throw new XPathException("Invalid variable name: " + err.getMessage() + (nameAttribute.startsWith("$") ? " (No '$' sign needed)" : ""), "XTSE0020", new AttributeLocation(this.sourceElement, n));
        }
    }

    private StructuredQName errorName() {
        return new StructuredQName("saxon", "http://saxon.sf.net/", "error-variable-name");
    }

    public void validate() throws XPathException {
        if (this.select != null && this.sourceElement.hasChildNodes()) {
            this.sourceElement.compileError("An " + this.sourceElement.getDisplayName() + " element with a select attribute must be empty", "XTSE0620");
        }
        if (this.hasProperty(512) && this.sourceElement.hasChildNodes()) {
            if (this.isStatic()) {
                this.sourceElement.compileError("A static variable or parameter must have no content", "XTSE0010");
            } else {
                this.sourceElement.compileError("Within xsl:function, an xsl:param element must have no content", "XTSE0620");
            }
        }
        if (this.visibility == Visibility.ABSTRACT && (this.select != null || this.sourceElement.hasChildNodes())) {
            this.sourceElement.compileError("An abstract variable must have no select attribute and no content", "XTSE0620");
        }
    }

    public void postValidate() throws XPathException {
        this.checkAgainstRequiredType(this.declaredType);
        if (this.select == null && !this.hasProperty(512) && this.visibility != Visibility.ABSTRACT) {
            AxisIterator kids = this.sourceElement.iterateAxis((byte)3);
            NodeInfo first = kids.next();
            if (first == null) {
                if (this.declaredType == null) {
                    this.select = new StringLiteral(StringValue.EMPTY_STRING);
                    this.select.setRetainedStaticContext(this.sourceElement.makeRetainedStaticContext());
                } else if (this.sourceElement instanceof XSLLocalParam || this.sourceElement instanceof XSLGlobalParam) {
                    if (!this.hasProperty(16)) {
                        if (Cardinality.allowsZero(this.declaredType.getCardinality())) {
                            this.select = Literal.makeEmptySequence();
                        } else {
                            this.setProperty(32, true);
                        }
                    }
                } else if (Cardinality.allowsZero(this.declaredType.getCardinality())) {
                    this.select = Literal.makeEmptySequence();
                    this.select.setRetainedStaticContext(this.sourceElement.makeRetainedStaticContext());
                } else {
                    this.sourceElement.compileError("The implicit value () is not valid for the declared type", "XTTE0570");
                }
            } else if (kids.next() == null && first.getNodeKind() == 3) {
                this.constantText = first.getStringValue();
            }
        }
        this.select = this.sourceElement.typeCheck("select", this.select);
    }

    public boolean isStatic() {
        return this.hasProperty(2048);
    }

    public void checkAgainstRequiredType(SequenceType required) throws XPathException {
        if (this.visibility != Visibility.ABSTRACT) {
            try {
                if (required != null && this.select != null) {
                    int category = 3;
                    String errorCode = "XTTE0570";
                    if (this.sourceElement instanceof XSLLocalParam) {
                        category = 8;
                        errorCode = "XTTE0600";
                    } else if (this.sourceElement instanceof XSLWithParam || this.sourceElement instanceof XSLGlobalParam) {
                        category = 8;
                        errorCode = "XTTE0590";
                    }
                    RoleDiagnostic role = new RoleDiagnostic(category, this.name.getDisplayName(), 0);
                    role.setErrorCode(errorCode);
                    this.select = this.sourceElement.getConfiguration().getTypeChecker(false).staticTypeCheck(this.select, required, role, this.sourceElement.makeExpressionVisitor());
                }
            }
            catch (XPathException err) {
                err.setLocator(this.sourceElement);
                this.sourceElement.compileError(err);
                this.select = new ErrorExpression(err);
            }
        }
    }

    public StructuredQName getVariableQName() {
        if (this.name == null) {
            try {
                this.processVariableName(this.sourceElement.getAttributeValue("", "name"));
            }
            catch (XPathException e) {
                return this.errorName();
            }
        }
        return this.name;
    }

    public void setProperty(int prop, boolean flag) {
        this.properties = flag ? (this.properties |= prop) : (this.properties &= ~prop);
    }

    public boolean hasProperty(int prop) {
        return (this.properties & prop) != 0;
    }

    public List<BindingReference> getReferences() {
        return this.references;
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public void handleSequenceConstructor(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        if (this.sourceElement.hasChildNodes()) {
            if (this.declaredType == null) {
                Expression b = this.sourceElement.compileSequenceConstructor(compilation, decl, true);
                if (b == null) {
                    b = Literal.makeEmptySequence();
                }
                boolean textonly = UType.TEXT.subsumes(b.getItemType().getUType());
                DocumentInstr doc = new DocumentInstr(textonly, this.constantText);
                doc.setContentExpression(b);
                doc.setRetainedStaticContext(this.sourceElement.makeRetainedStaticContext());
                this.select = doc;
            } else {
                this.select = this.sourceElement.compileSequenceConstructor(compilation, decl, true);
                if (this.select == null) {
                    this.select = Literal.makeEmptySequence();
                }
                try {
                    RoleDiagnostic role = new RoleDiagnostic(3, this.name.getDisplayName(), 0);
                    role.setErrorCode("XTTE0570");
                    this.select = this.select.simplify();
                    this.select = this.sourceElement.getConfiguration().getTypeChecker(false).staticTypeCheck(this.select, this.declaredType, role, this.sourceElement.makeExpressionVisitor());
                }
                catch (XPathException err) {
                    err.setLocator(this.sourceElement);
                    this.sourceElement.compileError(err);
                    this.select = new ErrorExpression(err);
                }
            }
        }
    }

    public SequenceType getDeclaredType() {
        if (this.declaredType == null) {
            String asAtt = this.sourceElement.getAttributeValue("", "as");
            if (asAtt == null) {
                return null;
            }
            try {
                this.declaredType = this.sourceElement.makeSequenceType(asAtt);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.declaredType;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public SequenceType getInferredType(boolean useContentRules) {
        Visibility visibility;
        if (this.inferredType != null) {
            return this.inferredType;
        }
        try {
            visibility = this.sourceElement.getVisibility();
        }
        catch (XPathException err) {
            visibility = Visibility.PUBLIC;
        }
        if (this.hasProperty(4) || this.hasProperty(64) || visibility != Visibility.PRIVATE && visibility != Visibility.FINAL) {
            SequenceType declared = this.getDeclaredType();
            this.inferredType = declared == null ? SequenceType.ANY_SEQUENCE : declared;
            return this.inferredType;
        }
        if (this.select != null) {
            TypeHierarchy th = this.sourceElement.getConfiguration().getTypeHierarchy();
            if (Literal.isEmptySequence(this.select)) {
                this.inferredType = this.declaredType == null ? SequenceType.ANY_SEQUENCE : this.declaredType;
                return this.inferredType;
            }
            ItemType actual = this.select.getItemType();
            int card = this.select.getCardinality();
            if (this.declaredType != null) {
                if (!th.isSubType(actual, this.declaredType.getPrimaryType())) {
                    actual = this.declaredType.getPrimaryType();
                }
                if (!Cardinality.subsumes(this.declaredType.getCardinality(), card)) {
                    card = this.declaredType.getCardinality();
                }
            }
            this.inferredType = SequenceType.makeSequenceType(actual, card);
            return this.inferredType;
        }
        if (useContentRules) {
            if (this.sourceElement.hasChildNodes()) {
                if (this.declaredType == null) {
                    return SequenceType.makeSequenceType(NodeKindTest.DOCUMENT, 16384);
                }
                return this.declaredType;
            }
            if (this.declaredType == null) {
                return SequenceType.SINGLE_STRING;
            }
            return this.declaredType;
        }
        return this.declaredType;
    }

    public void registerReference(BindingReference ref) {
        this.references.add(ref);
    }

    public GroundedValue getConstantValue() {
        if (this.constantValue == null) {
            int relation;
            SequenceType type = this.getInferredType(true);
            TypeHierarchy th = this.sourceElement.getConfiguration().getTypeHierarchy();
            if (!(this.hasProperty(64) || this.hasProperty(4) || this.visibility == Visibility.PUBLIC || this.visibility == Visibility.ABSTRACT || !(this.select instanceof Literal) || (relation = th.relationship(this.select.getItemType(), type.getPrimaryType())) != 0 && relation != 2)) {
                this.constantValue = ((Literal)this.select).getValue();
            }
        }
        return this.constantValue;
    }

    public void fixupReferences(GlobalVariable compiledGlobalVariable) throws XPathException {
        SequenceType type = this.getInferredType(true);
        TypeHierarchy th = this.sourceElement.getConfiguration().getTypeHierarchy();
        Object constantValue = null;
        int properties = 0;
        if (!this.hasProperty(64) && !this.hasProperty(4) && this.visibility != Visibility.PUBLIC && this.visibility != Visibility.ABSTRACT && this.select != null) {
            properties = this.select.getSpecialProperties();
        }
        for (BindingReference reference : this.references) {
            if (compiledGlobalVariable != null) {
                reference.fixup(compiledGlobalVariable);
            }
            reference.setStaticType(type, this.getConstantValue(), properties);
        }
    }

    protected void fixupBinding(Binding binding) {
        for (BindingReference reference : this.references) {
            reference.fixup(binding);
        }
    }
}

