# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 929;

use Math::BigFloat;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $expected) = split /:/;
    my ($x, $str);

    for my $accu ("undef", "20") {
        my $test = qq|Math::BigFloat -> accuracy($accu);|
                 . qq| \$x = Math::BigFloat -> new("$x_str");|
                 . qq| \$str = \$x -> bsstr();|;

        note "\n$test\n\n";
        eval $test;
        die $@ if $@;           # should never happen

        is($str, $expected, qq|output is "$expected"|);
        if ($x_str eq 'NaN') {
            ok($x -> is_nan(), "input object is unmodified");
        } else {
            cmp_ok($x, "==", $x_str, "input object is unmodified");
        }
    }
}

# Reset accuracy and precision.

Math::BigFloat -> accuracy(undef);
Math::BigFloat -> precision(undef);

# 355/113 rounded to 40 digits.

my $str = '3.141592920353982300884955752212389380531';

# Default rounding.

note(qq|\nMath::BigFloat -> new("$str") -> bsstr();\n\n|);
is(Math::BigFloat -> new($str) -> bsstr(),
   '3141592920353982300884955752212389380531e-39');

# Accuracy as argument.

note(qq|\nMath::BigFloat -> new("$str") -> bsstr(3);\n\n|);
is(Math::BigFloat -> new($str) -> bsstr(3), '314e-2');

# Precision as argument.

note(qq|\nMath::BigFloat -> new("$str") -> bsstr(undef, -3);\n\n|);
is(Math::BigFloat -> new($str) -> bsstr(undef, -3), '3142e-3');

# Accuracy as class variable.

note(qq|\nMath::BigFloat -> accuracy(5); Math::BigFloat -> new("$str") -> bsstr();\n\n|);
Math::BigFloat -> accuracy(5);
is(Math::BigFloat -> new($str) -> bsstr(), '31416e-4');

# Precision as class variable.

note(qq|\nMath::BigFloat -> precision(-5); Math::BigFloat -> new("$str") -> bsstr();\n\n|);
Math::BigFloat -> precision(-5);
is(Math::BigFloat -> new($str) -> bsstr(), '314159e-5');

__DATA__

NaN:NaN

inf:inf
-inf:-inf

0:0e+0
-0:0e+0

# positive numbers

0.000000000001:1e-12
0.00000000001:1e-11
0.0000000001:1e-10
0.000000001:1e-9
0.00000001:1e-8
0.0000001:1e-7
0.000001:1e-6
0.00001:1e-5
0.0001:1e-4
0.001:1e-3
0.01:1e-2
0.1:1e-1
1:1e+0
10:1e+1
100:1e+2
1000:1e+3
10000:1e+4
100000:1e+5
1000000:1e+6
10000000:1e+7
100000000:1e+8
1000000000:1e+9
10000000000:1e+10
100000000000:1e+11
1000000000000:1e+12

0.0000000000012:12e-13
0.000000000012:12e-12
0.00000000012:12e-11
0.0000000012:12e-10
0.000000012:12e-9
0.00000012:12e-8
0.0000012:12e-7
0.000012:12e-6
0.00012:12e-5
0.0012:12e-4
0.012:12e-3
0.12:12e-2
1.2:12e-1
12:12e+0
120:12e+1
1200:12e+2
12000:12e+3
120000:12e+4
1200000:12e+5
12000000:12e+6
120000000:12e+7
1200000000:12e+8
12000000000:12e+9
120000000000:12e+10
1200000000000:12e+11

0.00000000000123:123e-14
0.0000000000123:123e-13
0.000000000123:123e-12
0.00000000123:123e-11
0.0000000123:123e-10
0.000000123:123e-9
0.00000123:123e-8
0.0000123:123e-7
0.000123:123e-6
0.00123:123e-5
0.0123:123e-4
0.123:123e-3
1.23:123e-2
12.3:123e-1
123:123e+0
1230:123e+1
12300:123e+2
123000:123e+3
1230000:123e+4
12300000:123e+5
123000000:123e+6
1230000000:123e+7
12300000000:123e+8
123000000000:123e+9
1230000000000:123e+10

0.000000000001234:1234e-15
0.00000000001234:1234e-14
0.0000000001234:1234e-13
0.000000001234:1234e-12
0.00000001234:1234e-11
0.0000001234:1234e-10
0.000001234:1234e-9
0.00001234:1234e-8
0.0001234:1234e-7
0.001234:1234e-6
0.01234:1234e-5
0.1234:1234e-4
1.234:1234e-3
12.34:1234e-2
123.4:1234e-1
1234:1234e+0
12340:1234e+1
123400:1234e+2
1234000:1234e+3
12340000:1234e+4
123400000:1234e+5
1234000000:1234e+6
12340000000:1234e+7
123400000000:1234e+8
1234000000000:1234e+9

0.000003141592:3141592e-12
0.00003141592:3141592e-11
0.0003141592:3141592e-10
0.003141592:3141592e-9
0.03141592:3141592e-8
0.3141592:3141592e-7
3.141592:3141592e-6
31.41592:3141592e-5
314.1592:3141592e-4
3141.592:3141592e-3
31415.92:3141592e-2
314159.2:3141592e-1
3141592:3141592e+0

# negative numbers

-0.000000000001:-1e-12
-0.00000000001:-1e-11
-0.0000000001:-1e-10
-0.000000001:-1e-9
-0.00000001:-1e-8
-0.0000001:-1e-7
-0.000001:-1e-6
-0.00001:-1e-5
-0.0001:-1e-4
-0.001:-1e-3
-0.01:-1e-2
-0.1:-1e-1
-1:-1e+0
-10:-1e+1
-100:-1e+2
-1000:-1e+3
-10000:-1e+4
-100000:-1e+5
-1000000:-1e+6
-10000000:-1e+7
-100000000:-1e+8
-1000000000:-1e+9
-10000000000:-1e+10
-100000000000:-1e+11
-1000000000000:-1e+12

-0.0000000000012:-12e-13
-0.000000000012:-12e-12
-0.00000000012:-12e-11
-0.0000000012:-12e-10
-0.000000012:-12e-9
-0.00000012:-12e-8
-0.0000012:-12e-7
-0.000012:-12e-6
-0.00012:-12e-5
-0.0012:-12e-4
-0.012:-12e-3
-0.12:-12e-2
-1.2:-12e-1
-12:-12e+0
-120:-12e+1
-1200:-12e+2
-12000:-12e+3
-120000:-12e+4
-1200000:-12e+5
-12000000:-12e+6
-120000000:-12e+7
-1200000000:-12e+8
-12000000000:-12e+9
-120000000000:-12e+10
-1200000000000:-12e+11

-0.00000000000123:-123e-14
-0.0000000000123:-123e-13
-0.000000000123:-123e-12
-0.00000000123:-123e-11
-0.0000000123:-123e-10
-0.000000123:-123e-9
-0.00000123:-123e-8
-0.0000123:-123e-7
-0.000123:-123e-6
-0.00123:-123e-5
-0.0123:-123e-4
-0.123:-123e-3
-1.23:-123e-2
-12.3:-123e-1
-123:-123e+0
-1230:-123e+1
-12300:-123e+2
-123000:-123e+3
-1230000:-123e+4
-12300000:-123e+5
-123000000:-123e+6
-1230000000:-123e+7
-12300000000:-123e+8
-123000000000:-123e+9
-1230000000000:-123e+10

-0.000000000001234:-1234e-15
-0.00000000001234:-1234e-14
-0.0000000001234:-1234e-13
-0.000000001234:-1234e-12
-0.00000001234:-1234e-11
-0.0000001234:-1234e-10
-0.000001234:-1234e-9
-0.00001234:-1234e-8
-0.0001234:-1234e-7
-0.001234:-1234e-6
-0.01234:-1234e-5
-0.1234:-1234e-4
-1.234:-1234e-3
-12.34:-1234e-2
-123.4:-1234e-1
-1234:-1234e+0
-12340:-1234e+1
-123400:-1234e+2
-1234000:-1234e+3
-12340000:-1234e+4
-123400000:-1234e+5
-1234000000:-1234e+6
-12340000000:-1234e+7
-123400000000:-1234e+8
-1234000000000:-1234e+9

-0.000003141592:-3141592e-12
-0.00003141592:-3141592e-11
-0.0003141592:-3141592e-10
-0.003141592:-3141592e-9
-0.03141592:-3141592e-8
-0.3141592:-3141592e-7
-3.141592:-3141592e-6
-31.41592:-3141592e-5
-314.1592:-3141592e-4
-3141.592:-3141592e-3
-31415.92:-3141592e-2
-314159.2:-3141592e-1
-3141592:-3141592e+0
