package App::SeismicUnixGui::sunix::migration::sukdmig3d;

=head2 SYNOPSIS

PERL PROGRAM NAME: 

AUTHOR: Juan Lorenzo (Perl module only)

DATE:

DESCRIPTION:

Version:

=head2 USE

=head3 NOTES

=head4 Examples

=head2 SYNOPSIS

=head3 SEISMIC UNIX NOTES
SUKDMIG3D - Kirchhoff Depth Migration of 3D poststack/prestack data	



 	sukdmig3d datain= dataout= [parameters] 			



 Required parameters:							

 ttfile=file for input tttables			       	



 Optional Parameters:							



 datain=stdin	 file for input seismic traces				

 dataout=stdout file for common offset migration output		

 crfile=NULL    file for cos theta and ray paths                       



   The following 17 parameters describe tttables: (from ttfile header)	

 fxgd= or from header (f1)		first x-sample in tttable	

 nxt= or from header (ns)		number of x-samples in tttable	

 dxgd= or from header (d1)		x-interval in tttable 		

 fygd= or from header (f2)		first y-sample in tttable 	

 nyt= or from header (ntr)		number of y-samples in tttable	

 dygd= or from header (d2)		y-interval in tttable		

 ixsf= or from header (sdel) 	        x in dxgd of first source	

 nxs= or from header (nhs) 		number of sources in x		

 ixsr= or from header (swdep) 	        ratio of source & gd spacing    

 iysf= or from header (gdel)	        y in dygd of first source 	

 nys= or from header (nvs)		number of sources in y          

 iysr= or from header (gwdep)	        ratio of source & gd spacing    

 fzs= or from header (sdepth/1000)	first depth sample in tttable	

 nzs= or from header (duse) 		number of depth samples in tttable

 dzs= or from header (ep/1000)		depth interval in tttable	

 nxgd= or from header (selev)		x size of the traveltime region 

 nygd= or from header (gelev)		y size of the traveltime region 

 multit= or from header (scalel)       number of multivalued traveltime



   The following two parameters are from data header			

 dt= or from header (dt)	time sampling interval of input data	

 ft= or from header (ft)	first time sample of input data		

 dxm= or from header (d2)      mid point spacing of input data         



 Default: output is 5 times finer in depth and 2 times finer in lateral

 fzo=fzs	z-coordinate of first point in output trace		

 dzo=0.2*dzs	vertical spacing of output trace (5 times finer)	

 nzo=5*(nzs-1)+1 number of points in output trace (5 times finer)	",	

 fxo=fxgd	x-coordinate of first output trace	 		

 dxo=0.5*dxgd	horizontal spacing of output trace (2 times finer)	

 nxo=2*(nxgd-1)+1 number of output traces (2 times finer)		

 fyo=fygd	y-coordinate of first output trace			

 dyo=0.5*dygd	horizontal spacing of output trace (2 times finer)	

 nyo=2*(nygd-1)+1 number of output traces (2 times finer)		



 Default: poststack migration						",	

 fxoffset=0		first offest in output in x			

 fyoffset=0		first offest in output in y			

 dxoffset=99999	offset increment in output in x	 		

 dyoffset=99999	offset increment in output in y			

 nxoffset=1		number of offsets in output in x		

 nyoffset=1		number of offsets in output in y		",	

 xoffsetmax=99999	x-maximum absolute offset allowed in migration 	

 yoffsetmax=99999	y-maximum absolute offset allowed in migration  

 xaper=nxt*dxgd/2.5	migration lateral aperature in x		

 yaper=nyt*dygd/2.5	migration lateral aperature in y		

 angmax=60             max angle to handle                             

 fmax=0.25/dt          max frequency in the data                       

 jpfile=stderr		job print file name 				

 pptr=100		print verbal information at every pptr traces	

 ntrmax=100000		maximum number of input traces to be migrated	

 ls=0                  point =0 line source =1                         



 Notes:								

 1. Traveltime tables were generated by program SUTETRARAY (or other	

    ones) on very sparse tetrahedral model, with dimension nys*nxs*nzs 

    *nyt*nxt.                                                          

 2. Input seismic traces must be SU format and can be any type of 	

    gathers (common shot, common offset, common CDP, and so on).	", 

 3. Migrated traces are output in CDP gathers if velocity analysis	

    is required, with dimension nyoffset*nxoffset*nyo*nxo*nzo.		", 

 4. If the offset value of an input trace is not in the offset array 	

    of output, the nearest one in the array is chosen. 		

 5. Memory requirement for this program is about			

    [nys*nxs*nzs*nyt*nxt+nyoffset*nxoffset*nxo*nyo*nzo+	       	

    nys*nxo*nzo*nyt*nxt]                                               

 6. Input traces must specify source and receiver positions via header	

    fields tr.sx and tr.gx, as well as tr.sy and tr.gy. Offset is 	

    computed automatically.						



 Disclaimer:								

 This is a research code that will take considerable work to get into	

 the form of a a production level 3D migration code. The code is	

 offered as is, along with tetramod and sutetraray, to provide a starting

 point for researchers who wish to write their own 3D migration codes.







 Author:  Zhaobo Meng, 01/10/97,  Colorado School of Mines 



 Trace header fields accessed: ns, dt, delrt, d2

 Trace header fields modified: sx, gx



=head2 User's notes (Juan Lorenzo)
untested

=cut


=head2 CHANGES and their DATES

=cut

use Moose;
our $VERSION = '0.0.1';


=head2 Import packages

=cut

use aliased 'App::SeismicUnixGui::misc::L_SU_global_constants';

use App::SeismicUnixGui::misc::SeismicUnix qw($go $in $off $on $out $ps $to $suffix_ascii $suffix_bin $suffix_ps $suffix_segy $suffix_su);
use aliased 'App::SeismicUnixGui::configs::big_streams::Project_config';


=head2 instantiation of packages

=cut

my $get					= L_SU_global_constants->new();
my $Project				= Project_config->new();
my $DATA_SEISMIC_SU		= $Project->DATA_SEISMIC_SU();
my $DATA_SEISMIC_BIN	= $Project->DATA_SEISMIC_BIN();
my $DATA_SEISMIC_TXT	= $Project->DATA_SEISMIC_TXT();

my $PS_SEISMIC      	= $Project->PS_SEISMIC();

my $var				= $get->var();
my $on				= $var->{_on};
my $off				= $var->{_off};
my $true			= $var->{_true};
my $false			= $var->{_false};
my $empty_string	= $var->{_empty_string};

=head2 Encapsulated
hash of private variables

=cut

my $sukdmig3d			= {
	_angmax					=> '',
	_crfile					=> '',
	_datain					=> '',
	_dataout					=> '',
	_dt					=> '',
	_dxgd					=> '',
	_dxm					=> '',
	_dxo					=> '',
	_dxoffset					=> '',
	_dygd					=> '',
	_dyo					=> '',
	_dyoffset					=> '',
	_dzo					=> '',
	_dzs					=> '',
	_fmax					=> '',
	_ft					=> '',
	_fxgd					=> '',
	_fxo					=> '',
	_fxoffset					=> '',
	_fygd					=> '',
	_fyo					=> '',
	_fyoffset					=> '',
	_fzo					=> '',
	_fzs					=> '',
	_ixsf					=> '',
	_ixsr					=> '',
	_iysf					=> '',
	_iysr					=> '',
	_jpfile					=> '',
	_ls					=> '',
	_multit					=> '',
	_ntrmax					=> '',
	_nxgd					=> '',
	_nxo					=> '',
	_nxoffset					=> '',
	_nxs					=> '',
	_nxt					=> '',
	_nygd					=> '',
	_nyo					=> '',
	_nyoffset					=> '',
	_nys					=> '',
	_nyt					=> '',
	_nzo					=> '',
	_nzs					=> '',
	_pptr					=> '',
	_ttfile					=> '',
	_xaper					=> '',
	_xoffsetmax					=> '',
	_yaper					=> '',
	_yoffsetmax					=> '',
	_Step					=> '',
	_note					=> '',

};

=head2 sub Step

collects switches and assembles bash instructions
by adding the program name

=cut

 sub  Step {

	$sukdmig3d->{_Step}     = 'sukdmig3d'.$sukdmig3d->{_Step};
	return ( $sukdmig3d->{_Step} );

 }


=head2 sub note

collects switches and assembles bash instructions
by adding the program name

=cut

 sub  note {

	$sukdmig3d->{_note}     = 'sukdmig3d'.$sukdmig3d->{_note};
	return ( $sukdmig3d->{_note} );

 }



=head2 sub clear

=cut

 sub clear {

		$sukdmig3d->{_angmax}			= '';
		$sukdmig3d->{_crfile}			= '';
		$sukdmig3d->{_datain}			= '';
		$sukdmig3d->{_dataout}			= '';
		$sukdmig3d->{_dt}			= '';
		$sukdmig3d->{_dxgd}			= '';
		$sukdmig3d->{_dxm}			= '';
		$sukdmig3d->{_dxo}			= '';
		$sukdmig3d->{_dxoffset}			= '';
		$sukdmig3d->{_dygd}			= '';
		$sukdmig3d->{_dyo}			= '';
		$sukdmig3d->{_dyoffset}			= '';
		$sukdmig3d->{_dzo}			= '';
		$sukdmig3d->{_dzs}			= '';
		$sukdmig3d->{_fmax}			= '';
		$sukdmig3d->{_ft}			= '';
		$sukdmig3d->{_fxgd}			= '';
		$sukdmig3d->{_fxo}			= '';
		$sukdmig3d->{_fxoffset}			= '';
		$sukdmig3d->{_fygd}			= '';
		$sukdmig3d->{_fyo}			= '';
		$sukdmig3d->{_fyoffset}			= '';
		$sukdmig3d->{_fzo}			= '';
		$sukdmig3d->{_fzs}			= '';
		$sukdmig3d->{_ixsf}			= '';
		$sukdmig3d->{_ixsr}			= '';
		$sukdmig3d->{_iysf}			= '';
		$sukdmig3d->{_iysr}			= '';
		$sukdmig3d->{_jpfile}			= '';
		$sukdmig3d->{_ls}			= '';
		$sukdmig3d->{_multit}			= '';
		$sukdmig3d->{_ntrmax}			= '';
		$sukdmig3d->{_nxgd}			= '';
		$sukdmig3d->{_nxo}			= '';
		$sukdmig3d->{_nxoffset}			= '';
		$sukdmig3d->{_nxs}			= '';
		$sukdmig3d->{_nxt}			= '';
		$sukdmig3d->{_nygd}			= '';
		$sukdmig3d->{_nyo}			= '';
		$sukdmig3d->{_nyoffset}			= '';
		$sukdmig3d->{_nys}			= '';
		$sukdmig3d->{_nyt}			= '';
		$sukdmig3d->{_nzo}			= '';
		$sukdmig3d->{_nzs}			= '';
		$sukdmig3d->{_pptr}			= '';
		$sukdmig3d->{_ttfile}			= '';
		$sukdmig3d->{_xaper}			= '';
		$sukdmig3d->{_xoffsetmax}			= '';
		$sukdmig3d->{_yaper}			= '';
		$sukdmig3d->{_yoffsetmax}			= '';
		$sukdmig3d->{_Step}			= '';
		$sukdmig3d->{_note}			= '';
 }


=head2 sub angmax 


=cut

 sub angmax {

	my ( $self,$angmax )		= @_;
	if ( $angmax ne $empty_string ) {

		$sukdmig3d->{_angmax}		= $angmax;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' angmax='.$sukdmig3d->{_angmax};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' angmax='.$sukdmig3d->{_angmax};

	} else { 
		print("sukdmig3d, angmax, missing angmax,\n");
	 }
 }


=head2 sub crfile 


=cut

 sub crfile {

	my ( $self,$crfile )		= @_;
	if ( $crfile ne $empty_string ) {

		$sukdmig3d->{_crfile}		= $crfile;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' crfile='.$sukdmig3d->{_crfile};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' crfile='.$sukdmig3d->{_crfile};

	} else { 
		print("sukdmig3d, crfile, missing crfile,\n");
	 }
 }


=head2 sub datain 


=cut

 sub datain {

	my ( $self,$datain )		= @_;
	if ( $datain ne $empty_string ) {

		$sukdmig3d->{_datain}		= $datain;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' datain='.$sukdmig3d->{_datain};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' datain='.$sukdmig3d->{_datain};

	} else { 
		print("sukdmig3d, datain, missing datain,\n");
	 }
 }


=head2 sub dataout 


=cut

 sub dataout {

	my ( $self,$dataout )		= @_;
	if ( $dataout ne $empty_string ) {

		$sukdmig3d->{_dataout}		= $dataout;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dataout='.$sukdmig3d->{_dataout};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dataout='.$sukdmig3d->{_dataout};

	} else { 
		print("sukdmig3d, dataout, missing dataout,\n");
	 }
 }


=head2 sub dt 


=cut

 sub dt {

	my ( $self,$dt )		= @_;
	if ( $dt ne $empty_string ) {

		$sukdmig3d->{_dt}		= $dt;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dt='.$sukdmig3d->{_dt};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dt='.$sukdmig3d->{_dt};

	} else { 
		print("sukdmig3d, dt, missing dt,\n");
	 }
 }


=head2 sub dxgd 


=cut

 sub dxgd {

	my ( $self,$dxgd )		= @_;
	if ( $dxgd ne $empty_string ) {

		$sukdmig3d->{_dxgd}		= $dxgd;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dxgd='.$sukdmig3d->{_dxgd};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dxgd='.$sukdmig3d->{_dxgd};

	} else { 
		print("sukdmig3d, dxgd, missing dxgd,\n");
	 }
 }


=head2 sub dxm 


=cut

 sub dxm {

	my ( $self,$dxm )		= @_;
	if ( $dxm ne $empty_string ) {

		$sukdmig3d->{_dxm}		= $dxm;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dxm='.$sukdmig3d->{_dxm};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dxm='.$sukdmig3d->{_dxm};

	} else { 
		print("sukdmig3d, dxm, missing dxm,\n");
	 }
 }


=head2 sub dxo 


=cut

 sub dxo {

	my ( $self,$dxo )		= @_;
	if ( $dxo ne $empty_string ) {

		$sukdmig3d->{_dxo}		= $dxo;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dxo='.$sukdmig3d->{_dxo};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dxo='.$sukdmig3d->{_dxo};

	} else { 
		print("sukdmig3d, dxo, missing dxo,\n");
	 }
 }


=head2 sub dxoffset 


=cut

 sub dxoffset {

	my ( $self,$dxoffset )		= @_;
	if ( $dxoffset ne $empty_string ) {

		$sukdmig3d->{_dxoffset}		= $dxoffset;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dxoffset='.$sukdmig3d->{_dxoffset};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dxoffset='.$sukdmig3d->{_dxoffset};

	} else { 
		print("sukdmig3d, dxoffset, missing dxoffset,\n");
	 }
 }


=head2 sub dygd 


=cut

 sub dygd {

	my ( $self,$dygd )		= @_;
	if ( $dygd ne $empty_string ) {

		$sukdmig3d->{_dygd}		= $dygd;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dygd='.$sukdmig3d->{_dygd};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dygd='.$sukdmig3d->{_dygd};

	} else { 
		print("sukdmig3d, dygd, missing dygd,\n");
	 }
 }


=head2 sub dyo 


=cut

 sub dyo {

	my ( $self,$dyo )		= @_;
	if ( $dyo ne $empty_string ) {

		$sukdmig3d->{_dyo}		= $dyo;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dyo='.$sukdmig3d->{_dyo};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dyo='.$sukdmig3d->{_dyo};

	} else { 
		print("sukdmig3d, dyo, missing dyo,\n");
	 }
 }


=head2 sub dyoffset 


=cut

 sub dyoffset {

	my ( $self,$dyoffset )		= @_;
	if ( $dyoffset ne $empty_string ) {

		$sukdmig3d->{_dyoffset}		= $dyoffset;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dyoffset='.$sukdmig3d->{_dyoffset};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dyoffset='.$sukdmig3d->{_dyoffset};

	} else { 
		print("sukdmig3d, dyoffset, missing dyoffset,\n");
	 }
 }


=head2 sub dzo 


=cut

 sub dzo {

	my ( $self,$dzo )		= @_;
	if ( $dzo ne $empty_string ) {

		$sukdmig3d->{_dzo}		= $dzo;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dzo='.$sukdmig3d->{_dzo};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dzo='.$sukdmig3d->{_dzo};

	} else { 
		print("sukdmig3d, dzo, missing dzo,\n");
	 }
 }


=head2 sub dzs 


=cut

 sub dzs {

	my ( $self,$dzs )		= @_;
	if ( $dzs ne $empty_string ) {

		$sukdmig3d->{_dzs}		= $dzs;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' dzs='.$sukdmig3d->{_dzs};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' dzs='.$sukdmig3d->{_dzs};

	} else { 
		print("sukdmig3d, dzs, missing dzs,\n");
	 }
 }


=head2 sub fmax 


=cut

 sub fmax {

	my ( $self,$fmax )		= @_;
	if ( $fmax ne $empty_string ) {

		$sukdmig3d->{_fmax}		= $fmax;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' fmax='.$sukdmig3d->{_fmax};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' fmax='.$sukdmig3d->{_fmax};

	} else { 
		print("sukdmig3d, fmax, missing fmax,\n");
	 }
 }


=head2 sub ft 


=cut

 sub ft {

	my ( $self,$ft )		= @_;
	if ( $ft ne $empty_string ) {

		$sukdmig3d->{_ft}		= $ft;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' ft='.$sukdmig3d->{_ft};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' ft='.$sukdmig3d->{_ft};

	} else { 
		print("sukdmig3d, ft, missing ft,\n");
	 }
 }


=head2 sub fxgd 


=cut

 sub fxgd {

	my ( $self,$fxgd )		= @_;
	if ( $fxgd ne $empty_string ) {

		$sukdmig3d->{_fxgd}		= $fxgd;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' fxgd='.$sukdmig3d->{_fxgd};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' fxgd='.$sukdmig3d->{_fxgd};

	} else { 
		print("sukdmig3d, fxgd, missing fxgd,\n");
	 }
 }


=head2 sub fxo 


=cut

 sub fxo {

	my ( $self,$fxo )		= @_;
	if ( $fxo ne $empty_string ) {

		$sukdmig3d->{_fxo}		= $fxo;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' fxo='.$sukdmig3d->{_fxo};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' fxo='.$sukdmig3d->{_fxo};

	} else { 
		print("sukdmig3d, fxo, missing fxo,\n");
	 }
 }


=head2 sub fxoffset 


=cut

 sub fxoffset {

	my ( $self,$fxoffset )		= @_;
	if ( $fxoffset ne $empty_string ) {

		$sukdmig3d->{_fxoffset}		= $fxoffset;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' fxoffset='.$sukdmig3d->{_fxoffset};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' fxoffset='.$sukdmig3d->{_fxoffset};

	} else { 
		print("sukdmig3d, fxoffset, missing fxoffset,\n");
	 }
 }


=head2 sub fygd 


=cut

 sub fygd {

	my ( $self,$fygd )		= @_;
	if ( $fygd ne $empty_string ) {

		$sukdmig3d->{_fygd}		= $fygd;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' fygd='.$sukdmig3d->{_fygd};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' fygd='.$sukdmig3d->{_fygd};

	} else { 
		print("sukdmig3d, fygd, missing fygd,\n");
	 }
 }


=head2 sub fyo 


=cut

 sub fyo {

	my ( $self,$fyo )		= @_;
	if ( $fyo ne $empty_string ) {

		$sukdmig3d->{_fyo}		= $fyo;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' fyo='.$sukdmig3d->{_fyo};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' fyo='.$sukdmig3d->{_fyo};

	} else { 
		print("sukdmig3d, fyo, missing fyo,\n");
	 }
 }


=head2 sub fyoffset 


=cut

 sub fyoffset {

	my ( $self,$fyoffset )		= @_;
	if ( $fyoffset ne $empty_string ) {

		$sukdmig3d->{_fyoffset}		= $fyoffset;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' fyoffset='.$sukdmig3d->{_fyoffset};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' fyoffset='.$sukdmig3d->{_fyoffset};

	} else { 
		print("sukdmig3d, fyoffset, missing fyoffset,\n");
	 }
 }


=head2 sub fzo 


=cut

 sub fzo {

	my ( $self,$fzo )		= @_;
	if ( $fzo ne $empty_string ) {

		$sukdmig3d->{_fzo}		= $fzo;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' fzo='.$sukdmig3d->{_fzo};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' fzo='.$sukdmig3d->{_fzo};

	} else { 
		print("sukdmig3d, fzo, missing fzo,\n");
	 }
 }


=head2 sub fzs 


=cut

 sub fzs {

	my ( $self,$fzs )		= @_;
	if ( $fzs ne $empty_string ) {

		$sukdmig3d->{_fzs}		= $fzs;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' fzs='.$sukdmig3d->{_fzs};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' fzs='.$sukdmig3d->{_fzs};

	} else { 
		print("sukdmig3d, fzs, missing fzs,\n");
	 }
 }


=head2 sub ixsf 


=cut

 sub ixsf {

	my ( $self,$ixsf )		= @_;
	if ( $ixsf ne $empty_string ) {

		$sukdmig3d->{_ixsf}		= $ixsf;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' ixsf='.$sukdmig3d->{_ixsf};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' ixsf='.$sukdmig3d->{_ixsf};

	} else { 
		print("sukdmig3d, ixsf, missing ixsf,\n");
	 }
 }


=head2 sub ixsr 


=cut

 sub ixsr {

	my ( $self,$ixsr )		= @_;
	if ( $ixsr ne $empty_string ) {

		$sukdmig3d->{_ixsr}		= $ixsr;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' ixsr='.$sukdmig3d->{_ixsr};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' ixsr='.$sukdmig3d->{_ixsr};

	} else { 
		print("sukdmig3d, ixsr, missing ixsr,\n");
	 }
 }


=head2 sub iysf 


=cut

 sub iysf {

	my ( $self,$iysf )		= @_;
	if ( $iysf ne $empty_string ) {

		$sukdmig3d->{_iysf}		= $iysf;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' iysf='.$sukdmig3d->{_iysf};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' iysf='.$sukdmig3d->{_iysf};

	} else { 
		print("sukdmig3d, iysf, missing iysf,\n");
	 }
 }


=head2 sub iysr 


=cut

 sub iysr {

	my ( $self,$iysr )		= @_;
	if ( $iysr ne $empty_string ) {

		$sukdmig3d->{_iysr}		= $iysr;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' iysr='.$sukdmig3d->{_iysr};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' iysr='.$sukdmig3d->{_iysr};

	} else { 
		print("sukdmig3d, iysr, missing iysr,\n");
	 }
 }


=head2 sub jpfile 


=cut

 sub jpfile {

	my ( $self,$jpfile )		= @_;
	if ( $jpfile ne $empty_string ) {

		$sukdmig3d->{_jpfile}		= $jpfile;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' jpfile='.$sukdmig3d->{_jpfile};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' jpfile='.$sukdmig3d->{_jpfile};

	} else { 
		print("sukdmig3d, jpfile, missing jpfile,\n");
	 }
 }


=head2 sub ls 


=cut

 sub ls {

	my ( $self,$ls )		= @_;
	if ( $ls ne $empty_string ) {

		$sukdmig3d->{_ls}		= $ls;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' ls='.$sukdmig3d->{_ls};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' ls='.$sukdmig3d->{_ls};

	} else { 
		print("sukdmig3d, ls, missing ls,\n");
	 }
 }


=head2 sub multit 


=cut

 sub multit {

	my ( $self,$multit )		= @_;
	if ( $multit ne $empty_string ) {

		$sukdmig3d->{_multit}		= $multit;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' multit='.$sukdmig3d->{_multit};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' multit='.$sukdmig3d->{_multit};

	} else { 
		print("sukdmig3d, multit, missing multit,\n");
	 }
 }


=head2 sub ntrmax 


=cut

 sub ntrmax {

	my ( $self,$ntrmax )		= @_;
	if ( $ntrmax ne $empty_string ) {

		$sukdmig3d->{_ntrmax}		= $ntrmax;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' ntrmax='.$sukdmig3d->{_ntrmax};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' ntrmax='.$sukdmig3d->{_ntrmax};

	} else { 
		print("sukdmig3d, ntrmax, missing ntrmax,\n");
	 }
 }


=head2 sub nxgd 


=cut

 sub nxgd {

	my ( $self,$nxgd )		= @_;
	if ( $nxgd ne $empty_string ) {

		$sukdmig3d->{_nxgd}		= $nxgd;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nxgd='.$sukdmig3d->{_nxgd};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nxgd='.$sukdmig3d->{_nxgd};

	} else { 
		print("sukdmig3d, nxgd, missing nxgd,\n");
	 }
 }


=head2 sub nxo 


=cut

 sub nxo {

	my ( $self,$nxo )		= @_;
	if ( $nxo ne $empty_string ) {

		$sukdmig3d->{_nxo}		= $nxo;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nxo='.$sukdmig3d->{_nxo};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nxo='.$sukdmig3d->{_nxo};

	} else { 
		print("sukdmig3d, nxo, missing nxo,\n");
	 }
 }


=head2 sub nxoffset 


=cut

 sub nxoffset {

	my ( $self,$nxoffset )		= @_;
	if ( $nxoffset ne $empty_string ) {

		$sukdmig3d->{_nxoffset}		= $nxoffset;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nxoffset='.$sukdmig3d->{_nxoffset};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nxoffset='.$sukdmig3d->{_nxoffset};

	} else { 
		print("sukdmig3d, nxoffset, missing nxoffset,\n");
	 }
 }


=head2 sub nxs 


=cut

 sub nxs {

	my ( $self,$nxs )		= @_;
	if ( $nxs ne $empty_string ) {

		$sukdmig3d->{_nxs}		= $nxs;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nxs='.$sukdmig3d->{_nxs};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nxs='.$sukdmig3d->{_nxs};

	} else { 
		print("sukdmig3d, nxs, missing nxs,\n");
	 }
 }


=head2 sub nxt 


=cut

 sub nxt {

	my ( $self,$nxt )		= @_;
	if ( $nxt ne $empty_string ) {

		$sukdmig3d->{_nxt}		= $nxt;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nxt='.$sukdmig3d->{_nxt};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nxt='.$sukdmig3d->{_nxt};

	} else { 
		print("sukdmig3d, nxt, missing nxt,\n");
	 }
 }


=head2 sub nygd 


=cut

 sub nygd {

	my ( $self,$nygd )		= @_;
	if ( $nygd ne $empty_string ) {

		$sukdmig3d->{_nygd}		= $nygd;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nygd='.$sukdmig3d->{_nygd};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nygd='.$sukdmig3d->{_nygd};

	} else { 
		print("sukdmig3d, nygd, missing nygd,\n");
	 }
 }


=head2 sub nyo 


=cut

 sub nyo {

	my ( $self,$nyo )		= @_;
	if ( $nyo ne $empty_string ) {

		$sukdmig3d->{_nyo}		= $nyo;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nyo='.$sukdmig3d->{_nyo};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nyo='.$sukdmig3d->{_nyo};

	} else { 
		print("sukdmig3d, nyo, missing nyo,\n");
	 }
 }


=head2 sub nyoffset 


=cut

 sub nyoffset {

	my ( $self,$nyoffset )		= @_;
	if ( $nyoffset ne $empty_string ) {

		$sukdmig3d->{_nyoffset}		= $nyoffset;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nyoffset='.$sukdmig3d->{_nyoffset};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nyoffset='.$sukdmig3d->{_nyoffset};

	} else { 
		print("sukdmig3d, nyoffset, missing nyoffset,\n");
	 }
 }


=head2 sub nys 


=cut

 sub nys {

	my ( $self,$nys )		= @_;
	if ( $nys ne $empty_string ) {

		$sukdmig3d->{_nys}		= $nys;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nys='.$sukdmig3d->{_nys};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nys='.$sukdmig3d->{_nys};

	} else { 
		print("sukdmig3d, nys, missing nys,\n");
	 }
 }


=head2 sub nyt 


=cut

 sub nyt {

	my ( $self,$nyt )		= @_;
	if ( $nyt ne $empty_string ) {

		$sukdmig3d->{_nyt}		= $nyt;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nyt='.$sukdmig3d->{_nyt};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nyt='.$sukdmig3d->{_nyt};

	} else { 
		print("sukdmig3d, nyt, missing nyt,\n");
	 }
 }


=head2 sub nzo 


=cut

 sub nzo {

	my ( $self,$nzo )		= @_;
	if ( $nzo ne $empty_string ) {

		$sukdmig3d->{_nzo}		= $nzo;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nzo='.$sukdmig3d->{_nzo};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nzo='.$sukdmig3d->{_nzo};

	} else { 
		print("sukdmig3d, nzo, missing nzo,\n");
	 }
 }


=head2 sub nzs 


=cut

 sub nzs {

	my ( $self,$nzs )		= @_;
	if ( $nzs ne $empty_string ) {

		$sukdmig3d->{_nzs}		= $nzs;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' nzs='.$sukdmig3d->{_nzs};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' nzs='.$sukdmig3d->{_nzs};

	} else { 
		print("sukdmig3d, nzs, missing nzs,\n");
	 }
 }


=head2 sub pptr 


=cut

 sub pptr {

	my ( $self,$pptr )		= @_;
	if ( $pptr ne $empty_string ) {

		$sukdmig3d->{_pptr}		= $pptr;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' pptr='.$sukdmig3d->{_pptr};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' pptr='.$sukdmig3d->{_pptr};

	} else { 
		print("sukdmig3d, pptr, missing pptr,\n");
	 }
 }


=head2 sub ttfile 


=cut

 sub ttfile {

	my ( $self,$ttfile )		= @_;
	if ( $ttfile ne $empty_string ) {

		$sukdmig3d->{_ttfile}		= $ttfile;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' ttfile='.$sukdmig3d->{_ttfile};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' ttfile='.$sukdmig3d->{_ttfile};

	} else { 
		print("sukdmig3d, ttfile, missing ttfile,\n");
	 }
 }


=head2 sub xaper 


=cut

 sub xaper {

	my ( $self,$xaper )		= @_;
	if ( $xaper ne $empty_string ) {

		$sukdmig3d->{_xaper}		= $xaper;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' xaper='.$sukdmig3d->{_xaper};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' xaper='.$sukdmig3d->{_xaper};

	} else { 
		print("sukdmig3d, xaper, missing xaper,\n");
	 }
 }


=head2 sub xoffsetmax 


=cut

 sub xoffsetmax {

	my ( $self,$xoffsetmax )		= @_;
	if ( $xoffsetmax ne $empty_string ) {

		$sukdmig3d->{_xoffsetmax}		= $xoffsetmax;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' xoffsetmax='.$sukdmig3d->{_xoffsetmax};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' xoffsetmax='.$sukdmig3d->{_xoffsetmax};

	} else { 
		print("sukdmig3d, xoffsetmax, missing xoffsetmax,\n");
	 }
 }


=head2 sub yaper 


=cut

 sub yaper {

	my ( $self,$yaper )		= @_;
	if ( $yaper ne $empty_string ) {

		$sukdmig3d->{_yaper}		= $yaper;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' yaper='.$sukdmig3d->{_yaper};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' yaper='.$sukdmig3d->{_yaper};

	} else { 
		print("sukdmig3d, yaper, missing yaper,\n");
	 }
 }


=head2 sub yoffsetmax 


=cut

 sub yoffsetmax {

	my ( $self,$yoffsetmax )		= @_;
	if ( $yoffsetmax ne $empty_string ) {

		$sukdmig3d->{_yoffsetmax}		= $yoffsetmax;
		$sukdmig3d->{_note}		= $sukdmig3d->{_note}.' yoffsetmax='.$sukdmig3d->{_yoffsetmax};
		$sukdmig3d->{_Step}		= $sukdmig3d->{_Step}.' yoffsetmax='.$sukdmig3d->{_yoffsetmax};

	} else { 
		print("sukdmig3d, yoffsetmax, missing yoffsetmax,\n");
	 }
 }


=head2 sub get_max_index

max index = number of input variables -1
 
=cut
 
sub get_max_index {
 	  my ($self) = @_;
	my $max_index = 49;

    return($max_index);
}
 
 
1;
